% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_alert}
\alias{cli_alert}
\alias{cli_alert_success}
\alias{cli_alert_danger}
\alias{cli_alert_warning}
\alias{cli_alert_info}
\title{CLI alerts}
\usage{
cli_alert(text, id = NULL, class = NULL, wrap = FALSE, .envir = parent.frame())

cli_alert_success(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)

cli_alert_danger(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)

cli_alert_warning(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)

cli_alert_info(
  text,
  id = NULL,
  class = NULL,
  wrap = FALSE,
  .envir = parent.frame()
)
}
\arguments{
\item{text}{Text of the alert.}

\item{id}{Id of the alert element. Can be used in themes.}

\item{class}{Class of the alert element. Can be used in themes.}

\item{wrap}{Whether to auto-wrap the text of the alert.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
Alerts are typically short status messages.
}
\details{
\subsection{Success}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nbld <- 11
tbld <- prettyunits::pretty_sec(5.6)
cli_alert_success("Built \{.emph \{nbld\}\} status report\{?s\} in \{tbld\}.")
}\if{html}{\out{</div>}}

\if{html}{\figure{alert-success.svg}}
}

\subsection{Info}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfl <- "~/.cache/files/latest.cache"
cli_alert_info("Updating cache file \{.path \{cfl\}\}.")
}\if{html}{\out{</div>}}

\if{html}{\figure{alert-info.svg}}
}

\subsection{Warning}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfl <- "~/.cache/files/latest.cache"
cli_alert_warning("Failed to update cache file \{.path \{cfl\}\}.")
}\if{html}{\out{</div>}}

\if{html}{\figure{alert-warning.svg}}
}

\subsection{Danger}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cfl <- "~/.config/report.yaml"
cli_alert_danger("Cannot validate config file at \{.path \{cfl\}\}.")
}\if{html}{\out{</div>}}

\if{html}{\figure{alert-danger.svg}}
}

\subsection{Text wrapping}{

Alerts are printed without wrapping, unless you set \code{wrap = TRUE}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_alert_info("Data columns: \{.val \{names(mtcars)\}\}.")
cli_alert_info("Data columns: \{.val \{names(mtcars)\}\}.", wrap = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\figure{alert-wrap.svg}}
}
}
