% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_datetime.R
\name{format_datetime}
\alias{format_datetime}
\title{Readable date format to POSIX}
\usage{
format_datetime(format)
}
\arguments{
\item{format}{the format that needs to be transformed}
}
\value{
A \code{character} string (a POSIX standardised format)
}
\description{
Use this function to transform generic date/time info writing (dd-mm-yyyy) into POSIX standardised format (\%d-\%m-\%Y), see Examples.
}
\examples{
format_datetime("yyyy-mm-dd")

# Very hard to remember all these characters:
format(Sys.time(), "\%a \%b \%d \%Y \%X")

# Easy to remember and write the same as above:
format(Sys.time(), format_datetime("ddd mmm dd yyyy HH:MM:ss"))

# seconds since the Epoch, 1970-01-01 00:00:00
format(Sys.time(), format_datetime("epoch"))
}
