\name{getOptParam}
\alias{getOptParam}
\title{
Get the optimal SVM hyperparameters of a classification ensemble
}
\description{
To allow detailed reporting of the methods used to create classifiers, the \code{getOptParam} function retrieves the optimum hyperparameters for each SVM within an ensemble classifier, built using \code{\link{cfBuild}}.
}
\usage{
getOptParam(ensObj)
}
\arguments{
  \item{ensObj}{The classification ensemble (in the form of an R list) as generated by \code{\link{cfBuild}}}
}
\value{
Returns a matrix containing the optimal gamma and optimal cost for each SVM in the classification ensemble. For information about what these hyperparameters are and how they are determined, see the documentation for \code{\link{cfBuild}}.
}
\examples{
\dontrun{
data(iris)

irisClass <- iris[,5]
irisData  <- iris[,-5]

ens <- cfBuild(irisData, irisClass, bootNum = 100, ensNum = 100, parallel = TRUE, 
               cpus = 4, type = "SOCK")
               
optim <- getOptParam(ens)
optim
}
}
\keyword{array}
