% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tag_list.R
\name{tag_list}
\alias{tag_list}
\title{List tags.}
\usage{
tag_list(query = NULL, vocabulary_id = NULL, all_fields = FALSE,
  url = get_default_url(), as = "list", ...)
}
\arguments{
\item{query}{(character) A tag name query to search for, if given only tags
whose names contain this string will be returned}

\item{vocabulary_id}{(character) The id or name of a vocabulary, if given,
only tags that belong to this vocabulary will be returned}

\item{all_fields}{(logical) Return full tag dictionaries instead of
just names. Default: FALSE}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
List tags.
}
\examples{
\dontrun{
# list all tags
tag_list()

# search for a specific tag
tag_list(query = 'aviation')

# all fields
tag_list(all_fields = TRUE)

# give back different data formats
tag_list('aviation', as = 'json')
tag_list('aviation', as = 'table')
}
}

