% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidying_functions.R
\name{self_standardize}
\alias{self_standardize}
\title{Standardize circumplex scales using sample data}
\usage{
self_standardize(
  data,
  scales,
  na.rm = TRUE,
  prefix = "",
  suffix = "_z",
  append = TRUE
)
}
\arguments{
\item{data}{Required. A data frame or matrix containing at least circumplex
scales.}

\item{scales}{Required. A character vector containing the column names, or a
numeric vector containing the column indexes, for the variables (scale
scores) to be standardized.}

\item{na.rm}{Optional. A logical that determines whether to remove missing
values from scales when calculating the means and SDs used for
standardization (default = TRUE).}

\item{prefix}{Optional. A string to include at the beginning of the newly
calculated scale variables' names, before the scale name and \code{suffix}
(default = "").}

\item{suffix}{Optional. A string to include at the end of the newly
calculated scale variables' names, after the scale name and \code{prefix}
(default = "_z").}

\item{append}{Optional. A logical that determines whether the calculated
standardized scores should be added as columns to \code{data} in the output or
the standardized scores alone should be output (default = TRUE).}
}
\value{
A data frame that contains the self-standardized versions of
\code{scales}.
}
\description{
Take in a data frame containing circumplex scales (or items) and return that
same data frame with each specified variable transformed into standard scores
(i.e., z-scores) based on observed means and SDs.
}
\examples{
self_standardize(aw2009, scales = 1:8)
}
\seealso{
Other tidying functions: 
\code{\link{ipsatize}()},
\code{\link{norm_standardize}()},
\code{\link{score}()}
}
\concept{tidying functions}
