% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineplots.R
\name{make_lineplot}
\alias{make_lineplot}
\title{Create a line plot from a data frame through ggplotly}
\usage{
make_lineplot(
  dt,
  x,
  y,
  groups = NULL,
  faceted = FALSE,
  scales = "fixed",
  show_trend = FALSE,
  trend_method = "loess",
  ggtheme = "minimal",
  x_axis_label = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma",
  static = FALSE
)
}
\arguments{
\item{dt}{data.frame containing the data to plot.}

\item{x}{Value on the x axis.}

\item{y}{Value on the y axis.}

\item{groups}{Name of the column containing the different groups.}

\item{faceted}{If TRUE (default), each group will be plotted separately.}

\item{scales}{From ggplot2::facet_wrap: Should scales be 'fixed', 'free', or free in one dimension ('free_x', 'free_y'). Default is 'fixed'.}

\item{show_trend}{If TRUE, adds a ggplot2::geom_smooth() line to the plot.}

\item{trend_method}{The method ggplot2::geom_smooth will use. Default is 'loess', which is a local polynomial regression fit}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package, used in case plot_palette is unspecified or insufficient for the number of colors required.}

\item{static}{If TRUE, the output will be static ggplot chart instead of an interactive ggplotly chart. Default is FALSE.}
}
\value{
A plotly-ized version of a grouped ggplot line plot.
}
\description{
Create a line plot from a data frame through ggplotly
}
\examples{
make_lineplot(dt = ggplot2::mpg,
              x = 'hwy',
              y = 'cty',
              groups = 'manufacturer',
              faceted = FALSE)

make_lineplot(dt = ggplot2::mpg,
              x = 'hwy',
              y = 'cty',
              groups = 'manufacturer',
              faceted = TRUE,
              scales = 'free')

}
