% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromote.R
\name{default_chrome_args}
\alias{default_chrome_args}
\alias{get_chrome_args}
\alias{set_chrome_args}
\title{Default Chrome arguments}
\usage{
default_chrome_args()

get_chrome_args()

set_chrome_args(args)
}
\arguments{
\item{args}{A character vector of command-line arguments (or \code{NULL}) to be
used with every new \code{\link{ChromoteSession}}.}
}
\value{
A character vector of default command-line arguments to be used with
every new \code{\link{ChromoteSession}}
}
\description{
A character vector of command-line arguments passed when initializing any new
instance of \code{\link{Chrome}}. Single on-off arguments are passed as single values
(e.g.\code{"--disable-gpu"}), arguments with a value are given with a nested
character vector (e.g. \code{c("--force-color-profile", "srgb")}). See
\href{https://peter.sh/experiments/chromium-command-line-switches/}{here} for a
list of possible arguments.
}
\details{
Default chromote arguments are composed of the following values (when
appropriate):
\itemize{
\item \href{https://peter.sh/experiments/chromium-command-line-switches/#disable-gpu}{\code{"--disable-gpu"}}
\itemize{
\item \verb{Disables GPU hardware acceleration. If software renderer is not in place, then the GPU process won't launch.}
}
\item \href{https://peter.sh/experiments/chromium-command-line-switches/#no-sandbox}{\code{"--no-sandbox"}}
\itemize{
\item Only added when \code{CI} system environment variable is set, when the
user on a Linux system is not set, or when executing inside a Docker container.
\item \verb{Disables the sandbox for all process types that are normally sandboxed. Meant to be used as a browser-level switch for testing purposes only}
}
\item \href{https://peter.sh/experiments/chromium-command-line-switches/#disable-dev-shm-usage}{\code{"--disable-dev-shm-usage"}}
\itemize{
\item Only added when \code{CI} system environment variable is set or when inside a docker instance.
\item \verb{The /dev/shm partition is too small in certain VM environments, causing Chrome to fail or crash}
}
\item \href{https://peter.sh/experiments/chromium-command-line-switches/#force-color-profile}{\code{"--force-color-profile=srgb"}}
\itemize{
\item This means that screenshots taken on a laptop plugged into an external
monitor will often have subtly different colors than one taken when
the laptop is using its built-in monitor. This problem will be even
more likely across machines.
\item \verb{Force all monitors to be treated as though they have the specified color profile.}
}
\item \href{https://peter.sh/experiments/chromium-command-line-switches/#disable-extensions}{\code{"--disable-extensions"}}
\itemize{
\item \verb{Disable extensions.}
}
\item \href{https://peter.sh/experiments/chromium-command-line-switches/#mute-audio}{\code{"--mute-audio"}}
\itemize{
\item \verb{Mutes audio sent to the audio device so it is not audible during automated testing}
}
}
}
\section{Functions}{
\itemize{
\item \code{default_chrome_args()}: Returns a character vector of command-line
arguments passed when initializing Chrome. See Details for more
information.

\item \code{get_chrome_args()}: Retrieves the default command-line arguments
passed to \code{\link{Chrome}} during initialization. Returns either \code{NULL} or a
character vector.

\item \code{set_chrome_args()}: Sets the default command-line arguments
passed when initializing. Returns the updated defaults.

}}
\examples{
old_chrome_args <- get_chrome_args()

# Only disable the gpu and using `/dev/shm`
set_chrome_args(c("--disable-gpu", "--disable-dev-shm-usage"))

#... Make new `Chrome` or `ChromoteSession` instance

# Restore old defaults
set_chrome_args(old_chrome_args)
}
