% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_spectra.R
\name{cluster_spectra}
\alias{cluster_spectra}
\title{Function to cluster peaks by spectral similarity.}
\usage{
cluster_spectra(
  peak_table,
  chrom_list,
  peak_no = c(5, 100),
  alpha = 0.95,
  nboot = 1000,
  plot_dend = TRUE,
  plot_spectra = TRUE,
  verbose = TRUE,
  save = TRUE,
  parallel = TRUE,
  max.only = FALSE,
  ...
)
}
\arguments{
\item{peak_table}{Peak table from \code{\link{get_peaktable}}.}

\item{chrom_list}{A list of chromatograms in matrix form (timepoints x
wavelengths).}

\item{peak_no}{Minimum and maximum thresholds for the number of peaks a
cluster may have.}

\item{alpha}{Confidence threshold for inclusion of cluster.}

\item{nboot}{Number of bootstrap replicates for
\code{\link[pvclust:pvclust]{pvclust}}.}

\item{plot_dend}{Logical. If TRUE, plots dendrogram with bootstrap values.}

\item{plot_spectra}{Logical. If TRUE, plots overlapping spectra for each
cluster.}

\item{verbose}{Logical. If TRUE, prints progress report to console.}

\item{save}{Logical. If TRUE, saves pvclust object to current directory.}

\item{parallel}{Logical. If TRUE, use parallel processing for
\code{\link[pvclust:pvclust]{pvclust}}.}

\item{max.only}{Logical. If TRUE, returns only highest level for nested
dendrograms.}

\item{...}{Additional arguments to \code{\link[pvclust:pvclust]{pvclust}}.}
}
\value{
Returns S4 "cluster" object with the following components:
\item{peaks}{a character vector containing the names of all peaks contained
in the given cluster.} \item{pval}{a numeric vector of length 1 containing
the bootstrap p-value (au) for the given cluster.}
}
\description{
Function to cluster peaks by spectral similarity. A representative spectrum
is selected for each peak in the provided peak table and used to construct a
distance matrix based on spectral similarity (pearson correlation) between
peaks. Currently, representative spectrum is just selected from the
chromatogram with the highest absorbance at lambda max. Hierarchical
clustering with bootstrap resampling is performed on the resulting
correlation matrix, as implemented in the
\code{\link[pvclust:pvclust]{pvclust}} package. Bootstrap values can be used
to select clusters that exceed a certain confidence threshold as defined by
alpha.
}
\examples{
\donttest{
data(pk_tab)
data(Sa_warp)
cl <- cluster_spectra(pk_tab, nboot=100, max.only = FALSE, save = FALSE, alpha = .97)
}
}
\references{
R. Suzuki, H. Shimodaira: Pvclust: an R package for assessing
the uncertainty in hierarchical clustering. Bioinformatics, 22-12:1540-1542
(2006). \doi{10.1093/bioinformatics/btl117}.
}
\author{
Ethan Bass
}
