% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chroms.R
\name{read_chroms}
\alias{read_chroms}
\title{Read Chromatograms}
\usage{
read_chroms(
  paths,
  find_files,
  format_in = c("chemstation_uv", "chemstation_csv", "masshunter_dad", "shimadzu_fid",
    "shimadzu_dad", "chromeleon_uv", "thermoraw", "mzml", "waters_arw", "msd", "csd",
    "wsd", "other"),
  pattern = NULL,
  parser = c("", "chromconverter", "aston", "entab", "thermoraw", "openchrom"),
  format_out = c("matrix", "data.frame"),
  export = FALSE,
  path_out = NULL,
  export_format = c("csv", "cdf", "mzml", "animl"),
  read_metadata = TRUE,
  dat = NULL
)
}
\arguments{
\item{paths}{paths to files or folders containing files}

\item{find_files}{Logical. Set to \code{TRUE} (default) if you are providing
the function with a folder or vector of folders containing the files.
Otherwise, set to\code{FALSE}.}

\item{format_in}{Format of files to be imported/converted. The current options
are: \code{chemstation_uv}, \code{chemstation_csv}, \code{masshunter_dad}, \code{shimadzu_fid},
\code{shimadzu_dad}, \code{chromeleon_uv}, \code{thermoraw}, \code{mzml},
\code{waters_arw}, \code{msd}, \code{csd}, \code{wsd}, or \code{other}.}

\item{pattern}{pattern (e.g. a file extension). Defaults to NULL, in which
case file extension will be deduced from \code{format_in}.}

\item{parser}{What parser to use. Current option are \code{chromconverter},
\code{aston}, \code{entab}, \code{thermoraw}, or \code{openchrom}.}

\item{format_out}{R object format (i.e. data.frame or matrix).}

\item{export}{Logical. If TRUE, will export files as csvs.}

\item{path_out}{Path for exporting files. If path not specified, files will
export to current working directory.}

\item{export_format}{Export format. Currently the only option is \code{.csv},
unless you are using OpenChrom parsers, where you could have \code{csv},
\code{cdf}, \code{mzml}, or \code{animl}.}

\item{read_metadata}{Logical, whether to attach metadata (if it's available).
Defaults to TRUE.}

\item{dat}{Existing list of chromatograms to append results.
(Defaults to NULL).}
}
\value{
A list of chromatograms in \code{matrix} or \code{data.frame} format,
according to the value of \code{format_out}.
}
\description{
Reads chromatograms from specified folders or vector of paths using file parsers
from \href{https://github.com/bovee/aston}{Aston}, \href{https://github.com/bovee/entab}{Entab},
and \href{https://github.com/compomics/ThermoRawFileParser}{ThermoRawFileParser}.
}
\details{
Currently recognizes Agilent ChemStation '.uv', MassHunter '.dad' files, and
ThermoRaw files. To use Entab and the ThermoRawFileParser, they
must be manually installed. Please see the instructions in the Read Me.
}
\section{Side effects}{
 If \code{export} is TRUE, chromatograms will be
exported in the format specified by \code{export_format} in the folder specified
by \code{path_out}. Currently, the only option for export is \code{csv} unless
the \code{parser} is \code{openchrom}.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
path <- "tests/testthat/testdata/dad1.uv"
chr <- read_chroms(path, find_files = FALSE, format_in = "chemstation_uv")
\dontshow{\}) # examplesIf}
}
\author{
Ethan Bass
}
