% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNeighborhoodEuclidean.R
\name{addNeighborhoodEuclidean}
\alias{addNeighborhoodEuclidean}
\title{Add expected Euclidean pump neighborhoods.}
\usage{
addNeighborhoodEuclidean(pump.subset = NULL, pump.select = NULL,
  vestry = FALSE, case.location = "nominal", type = "star",
  alpha.level = 0.5, polygon.method = "traveling.salesman",
  multi.core = FALSE)
}
\arguments{
\item{pump.subset}{Numeric. Vector of numeric pump IDs to subset from the neighborhoods defined by \code{pump.select}. Negative selection possible. \code{NULL} selects all pumps in \code{pump.select}.}

\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. \code{NULL} selects all pumps.}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{case.location}{Character. "address" or "nominal". "address" is the x-y coordinates of \code{sim.ortho.proj}. "nominal" is the x-y coordinates of \code{regular.cases}.}

\item{type}{Character. Type of plot: "star", "area.points" or "area.polygons".}

\item{alpha.level}{Numeric. Alpha level transparency for area plot: a value in [0, 1].}

\item{polygon.method}{Character. Method of computing polygon vertices: "pearl.string" or "traveling.salesman".}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. On Windows, only \code{multi.core = FALSE} is available.}
}
\value{
R graphic elements.
}
\description{
Add expected Euclidean pump neighborhoods.
}
\note{
This uses an approximate computation of polygons, using the 'TSP' package, that may produce non-simple and/or overlapping polygons.
}
\examples{
\dontrun{

streetNameLocator("marshall street", zoom = 0.5, highlight = FALSE,
  add.subtitle = FALSE)
addNeighborhoodEuclidean()

streetNameLocator("marshall street", zoom = 0.5, highlight = FALSE,
  add.subtitle = FALSE)
addNeighborhoodEuclidean(type = "area.points")
}
}
