% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addKernelDensity.R
\name{addKernelDensity}
\alias{addKernelDensity}
\title{Add 2D kernel density contours.}
\usage{
addKernelDensity(bandwidth = 0.5, color = "black", line.type = "solid",
  data = NULL, ...)
}
\arguments{
\item{bandwidth}{Numeric. Bandwidth for kernel density estimation.}

\item{color}{Character. Color of contour lines.}

\item{line.type}{Character. Line type for contour lines.}

\item{data}{Character. NULL uses \code{fatalities.unstacked}. "address" uses \code{fatalities.address}. "fatality" uses \code{fatalities}.}

\item{...}{Additional plotting parameters.}
}
\value{
Add contours to a graphics plot.
}
\description{
Uses KernSmooth::bkde2D().
}
\examples{
snowMap(add.landmarks = FALSE)
addKernelDensity()
}
\seealso{
\code{\link{snowMap}},
\code{\link{addIndexCase}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addSnow}},
\code{\link{addVoronoi}},
\code{\link{addWhitehead}}
}
