% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chkptstanr-package.R
\docType{package}
\name{chkptstanr-package}
\alias{chkptstanr-package}
\title{chkptstanr: Checkpoint MCMC Sampling with 'Stan'}
\description{
Fit Bayesian models in \strong{Stan} \insertCite{carpenter2017stan}{chkptstanr}
with checkpointing, that is, the ability to stop the MCMC sampler at will,
and then pick right back up where the MCMC sampler left off. Custom \strong{Stan} models
can be fitted, or the popular package \strong{brms} \insertCite{burkner2017brms}{chkptstanr}
can be used to generate the \strong{Stan} code. This package is fully compatible with the
\code{R} packages \href{http://paul-buerkner.github.io/brms/}{\strong{brms}},
\href{https://mc-stan.org/posterior/}{\strong{posterior}},
\href{https://mc-stan.org/cmdstanr/}{\strong{cmdstanr}}, and
\href{https://mc-stan.org/bayesplot/}{\strong{bayesplot}}.

There are a variety of use cases for \strong{chkptstanr},
including (but not limited to) the following:

\itemize{

\item The primary motivation for developing  \strong{chkptstanr} is to
reduce the cost of fitting models with \strong{Stan} when using, say, AWS,
and in particular by taking advantage of so-called \emph{spot instances}.
These instances are "a cost-effective choice if you can be flexible about
when your applications run and if your applications can be
\emph{interrupted} [emphasis added]"
(\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances.html}{AWS website}).

\strong{chkptstanr} thus allows for taking advantage of spot instances by
enabling "interruptions" during model fitting. This can reduce the cost
by 90 \%.

\item \strong{Stan} allows for fitting complex models. This often entails
iteratively improving the model to ensure that the MCMC algorithm
has converged. Typically this requires waiting until the model has
\emph{finished sampling}, and then assessing MCMC diagnostics (e.g., R-hat).

\strong{chkptstanr} can be used to make iterative model building more
efficient, e.g., by having the ability to pause sampling and examine the model
(e.g., convergence diagnostics), and then deciding to stop sampling or to continue on.

\item Computationally intensive models can sometimes take several days to
finish up. When using a personal computer, this can take up all
the computing resources.

\strong{chkptstanr} can be used with scheduling, such that the model is fitted
during certain windows (e.g., at night, weekends, etc.)

\item Those familiar with Bayesian methods will know all too well that a model can take
longer than expected. This can be problematic when there is another task
that needs to be completed, because one is faced with
waiting it out or stopping the model (and loosing all of the progress).

\strong{chkptstanr} makes it so that models can be conveniently stopped
if need be, while not loosing any of the progress.

}
}
\references{
\insertAllCited{}
}
