% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chkpt_brms.R
\name{chkpt_brms}
\alias{chkpt_brms}
\title{Checkpoint Sampling: brms}
\usage{
chkpt_brms(
  formula,
  data,
  iter_warmup = 1000,
  iter_sampling = 1000,
  iter_per_chkpt = 100,
  iter_typical = 150,
  parallel_chains = 2,
  threads_per = 1,
  chkpt_progress = TRUE,
  control = NULL,
  brmsfit = TRUE,
  seed = 1,
  path,
  ...
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats]{formula}},
\code{\link[brms]{brmsformula}}, or \code{\link{brms}{mvbrmsformula}}.
Further information can be found in  \code{\link[brms]{brmsformula}}.}

\item{data}{An object of class \code{data.frame} (or one that can be coerced to that class)
containing data of all variables used in the model.}

\item{iter_warmup}{(positive integer) The number of warmup iterations to run
per chain (defaults to 1000).}

\item{iter_sampling}{(positive integer) The number of post-warmup iterations
to run per chain (defaults to 1000).}

\item{iter_per_chkpt}{(positive integer). The number of iterations per
checkpoint. Note that \code{iter_sampling} is divided
by \code{iter_per_chkpt} to determine the number of
checkpoints. This must result in an integer
(if not, there will be an error).}

\item{iter_typical}{(positive integer) The number of iterations in the
initial warmup, which finds the so-called typical set.
This is an initial phase, and not included in
\code{iter_warmup}. Note that a large enough value
is required to ensure convergence (defaults to 150).}

\item{parallel_chains}{(positive integer) The \emph{maximum number} of MCMC
chains to run in parallel. If parallel_chains is not
specified then the default is to look for the option
\code{mc.cores}, which can be set for an entire R session by
\code{options(mc.cores=value)}. If the \code{mc.cores}
option has not been set then the default is \code{1}.}

\item{threads_per}{(positive integer) Number of threads to use in within-chain
parallelization (defaults to \code{1}).}

\item{chkpt_progress}{logical. Should the \code{chkptstanr} progress
be printed (defaults to \code{TRUE}) ? If set to
\code{FALSE}, the standard \code{cmdstanr} progress
bar is printed for each checkpoint
(which does not actually keep track of
checkpointing progress)}

\item{control}{A named list of parameters to control the sampler's behavior.
It defaults to NULL so all the default values are used.
For a comprehensive overview see \code{\link[rstan]{stan}}.}

\item{brmsfit}{Logical. Should a \code{brmsfit} object be returned
(defaults to \code{TRUE}).}

\item{seed}{(positive integer). The seed for random number generation to
make results reproducible.}

\item{path}{Character string. The path to the folder, that is used for
saving the checkpoints.}

\item{...}{Additional arguments based to \code{\link[brms]{make_stancode}},
including, for example, user-defined prior distributions and the
\code{\link[brms]{brmsfamily}} (e.g., \code{family = poisson())}.}
}
\value{
An object of class \code{brmsfit} (with \code{brmsfit = TRUE})
or \code{chkpt_brms} (with \code{brmsfit = FALSE})
}
\description{
Fit Bayesian generalized (non-)linear multivariate multilevel models using brms
with checkpointing.
}
\examples{
\dontrun{
library(brms)
library(cmdstanr)

# path for storing checkpoint info
path <- create_folder(folder_name  = "chkpt_folder_fit1")

# "random" intercept
fit1 <- chkpt_brms(bf(formula = count ~ zAge + zBase * Trt + (1|patient),
                      family = poisson()), 
                   data = epilepsy, , 
                   iter_warmup = 1000, 
                   iter_sampling = 1000, 
                   iter_per_chkpt = 250, 
                   path = path)
                   
# brmsfit output
fit1

# path for storing checkpoint info
 path <- create_folder(folder_name  = "chkpt_folder_fit2")

# remove "random" intercept (for model comparison)
fit2 <- chkpt_brms(bf(formula = count ~ zAge + zBase * Trt, 
                      family = poisson()), 
                   data = epilepsy, , 
                   iter_warmup = 1000, 
                   iter_sampling = 1000, 
                   iter_per_chkpt = 250, 
                   path = path)
                   
# brmsfit output
fit2

# compare models
loo(fit1, fit2)


# using custom priors
path <- create_folder(folder_name = "chkpt_folder_fit3")

# priors
bprior <- prior(constant(1), class = "b") +
  prior(constant(2), class = "b", coef = "zBase") +
  prior(constant(0.5), class = "sd")

# fit model
fit3 <-
  chkpt_brms(
    bf(
      formula = count ~ zAge + zBase + (1 | patient),
      family = poisson()
    ),
    data = epilepsy,
    path  = path,
    prior = bprior,
    iter_warmup = 1000,
    iter_sampling = 1000,
    iter_per_chkpt = 250, 
  )


# check priors
prior_summary(fit3)

}
}
