% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-datetime.R
\name{chk_date_time}
\alias{chk_date_time}
\alias{chk_datetime}
\alias{vld_date_time}
\alias{vld_datetime}
\title{Check Date Time}
\usage{
chk_date_time(x, x_name = NULL)

chk_datetime(x, x_name = NULL)

vld_date_time(x)

vld_datetime(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if non-missing POSIXct scalar using

\code{inherits(x, "POSIXct") && length(x) == 1L && !anyNA(x)}
}
\section{Functions}{
\itemize{
\item \code{chk_datetime()}: Check Date Time (Deprecated)

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\item \code{vld_date_time()}: Validate Date Time

\item \code{vld_datetime()}: Validate Date Time (Deprecated)

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

}}
\examples{
# chk_date_time
chk_date_time(as.POSIXct("2001-01-02"))
try(chk_date_time(1))
# vld_date_time
vld_date_time(as.POSIXct("2001-01-02"))
vld_date_time(Sys.time())
vld_date_time(1)
vld_date_time("2001-01-02")
vld_date_time(c(Sys.time(), Sys.time()))
}
\seealso{
Other chk_scalars: 
\code{\link{chk_date}()},
\code{\link{chk_number}()},
\code{\link{chk_scalar}()},
\code{\link{chk_string}()},
\code{\link{chk_tz}()},
\code{\link{chk_whole_number}()}
}
\concept{chk_scalars}
