% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-setequal.R
\name{chk_setequal}
\alias{chk_setequal}
\alias{vld_setequal}
\title{Check Set Equal}
\usage{
chk_setequal(x, values, x_name = NULL)

vld_setequal(x, values)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A vector of the permitted values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if equal set using

\code{setequal(x, values)}
}
\section{Functions}{
\itemize{
\item \code{vld_setequal}: Validate Set Equal
}}

\examples{

# chk_setequal
chk_setequal(1:2, 2:1)
try(chk_setequal(1, 1:2))

# vld_setequal
vld_setequal(1, 1)
vld_setequal(1:2, 2:1)
vld_setequal(1, 2:1)
vld_setequal(1:2, 2)
}
\seealso{
Other chk_set: 
\code{\link{chk_subset}()},
\code{\link{chk_superset}()}
}
\concept{chk_set}
