% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc.R
\name{cc}
\alias{cc}
\title{Concatenate with Commas}
\usage{
cc(x, conj = ", ", sep = ", ", brac = if (is.character(x) ||
  is.factor(x)) "'" else "", ellipsis = 10L, chk = TRUE)
}
\arguments{
\item{x}{The object to concatenate.}

\item{conj}{A string of the conjunction to separate the last value by.}

\item{sep}{A string of the separator.}

\item{brac}{A string to brac the values by.}

\item{ellipsis}{A numeric scalar of the maximum number of values to display
before using an ellipsis.}

\item{chk}{A flag specifying whether to check the other parameters.}
}
\value{
A string.
}
\description{
Concatenates object values into a string with each value separated by a comma
and the last value separated by a conjunction.
}
\details{
By default, if x has more than 10 values an ellipsis is used
to ensure only 10 values are displayed (including the ellipsis).
}
\examples{
cc(1:2)
cc(1:2, conj = " or")
cc(3:1, brac = "'")
cc(1:11)
cc(as.character(1:2))
}
