% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chillR-package.R
\docType{package}
\name{chillR-package}
\alias{chillR-package}
\title{\if{html}{\figure{chillR.png}{options: width='25\%' alt='chillR logo'}}
chillR: statistical methods for phenology analysis in temperate fruit trees}
\description{
\if{latex}{\figure{chillR.png}{options: width=1in}}

\code{chillR} contains functions for processing temperature records into chilling (Chilling Hours, Utah Chill Units
and Chill Portions) and heat units (Growing Degree Hours). Regarding chilling metrics, Chill Portions are often
considered the most promising, but they are difficult to calculate. This package makes it easy.
\code{chillR} also contains procedures for conducting a Partial Least Square regression analysis relating
phenological dates (e.g. bloom dates) to either mean temperatures or mean chill and heat accumulation rates,
based on long-term weather and phenology records (Luedeling and Gassner 2012).
As of version 0.65, it also includes functions for generating weather scenarios with a weather generator,
for conducting climate change analyses for temperature-based climatic metrics and for plotting results from such
analyses. Since version 0.70, \code{chillR} contains a function for interpolating hourly temperature records.
As of version 0.72.6, the package contains functions to design elegant plots using the \code{\link{ggplot2}} package.
}
\references{
Luedeling E and Gassner A, 2012. Partial Least Squares Regression for
analyzing walnut phenology in California. Agricultural and Forest
Meteorology 158, 43-52. \doi{10.1016/j.agrformet.2011.10.020}
}
\author{
\tabular{ll}{
\strong{Prof. Dr. Eike Luedeling} (creator)\cr
\email{eike@eikeluedeling.com}\cr   
\href{https://orcid.org/0000-0002-7316-3631}{ORCID}\cr
\href{https://github.com/eikeluedeling}{eikeluedeling on GitHub}\cr   
 \cr
\strong{Lars Caspersen} (contributor)\cr
\email{lcaspers@uni-bonn.de}\cr
\href{https://orcid.org/0009-0000-3057-7327}{ORCID}\cr
\href{https://github.com/larscaspersen}{larscaspersen on GitHub}\cr
 \cr
\strong{Dr. Eduardo Fernández} (contributor)\cr
\email{eduardo.fernandez.c@pucv.cl}\cr
\href{https://orcid.org/0000-0002-6949-9685}{ORCID}\cr
\href{https://github.com/EduardoFernandezC}{EduardoFernandezC on GitHub}
}
}
