% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSEP_RPD.R
\name{RMSEP}
\alias{RMSEP}
\title{Root Mean Square Error of Prediction (RMSEP)}
\usage{
RMSEP(predicted, observed, na.rm = FALSE)
}
\arguments{
\item{predicted}{a numeric vector containing predicted values.}

\item{observed}{a numeric vector of the same length as ```predicted```
containing observed values.}

\item{na.rm}{Boolean parameter indicating whether NA values should be removed before the analysis}
}
\value{
numeric value of the RMSEP.
}
\description{
This function computes the Root Mean Square Error of Prediction (RMSEP),
a commonly used measure for the predictive capacity of a model. It
compares values predicted with a model with observed values.
}
\examples{

predicted<-c(1,2,3,4,5,6,7,8,9,10)
observed<-c(1.5,1.8,3.3,3.9,4.4,6,7.5,9,11,10)

RMSEP(predicted,observed)

}
\author{
Eike Luedeling
}
\keyword{model}
\keyword{validation}
