% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_scenario_from_records.R
\name{temperature_scenario_from_records}
\alias{temperature_scenario_from_records}
\title{Make monthly temperature scenario from historic records}
\usage{
temperature_scenario_from_records(
  weather,
  year,
  weather_start = NA,
  weather_end = NA,
  scen_type = "running_mean",
  runn_mean = 15
)
}
\arguments{
\item{weather}{daily weather, as produced with the fix_weather
function. Can also be generated by other means, but shouold contain the columns
c("Month","Day","Year","Tmin","Tmax").}

\item{year}{numeric vector of years, for which the scenario is to be produced.}

\item{weather_start}{start year of the period to be considered in calculating the regression.
Defaults to NA, which means the first year of the record is used as start year.}

\item{weather_end}{end year of the period to be considered in calculating the regression.
Defaults to NA, which means the last year of the record is used as end year.}

\item{scen_type}{character string, either "regression" or "running_mean", specifying how the
scenario should be produced. "regression" computed the scenario based on an assumed linear trend
in the data; "running_mean" uses a running mean function instead, with the length of the
running mean window determined by the runn_mean parameter. The default is a running mean function,
since the assumption of a linear trend often does not hold.}

\item{runn_mean}{number of vector elements to use for calculating the
running mean; this is reduced, if the time series is not long enough to accommodate the specified
window. Defaults to 15.}
}
\value{
list of climate scenario objects, consisting of the following elements: 'data' =
a data frame with n_intervals elements containing the absolute temperature information.
'scenario_year' = the year the scenario is representative of, i.e. the specified 'year' parameter.
'reference_year' = NA (because this is an absolute temperature scenarios, not a 
relative one); 'scenario_type' = 'absolute' (because this is an absolute temperature
scenario, not a relative one); 'labels' = 'regression-based scenario'.
}
\description{
Produces a list of scenarios containing monthly means for Tmin and Tmax that are representative
of particular years. These scenario are computed by applying linear regression to a
file containing Tmin and Tmax records, and using the regression model to calculate typical
values for the user-specified years.
}
\details{
This function produces outputs that can be used as input for the temperature_generation
function. Sample applications are the use of the temperature_generation function for
making replicate weather records for a given year for risk assessment purposes, or
the generation of a weather scenario that can be compared with other datasets (e.g. climate
scenarios based on the WorldClim dataset refer to a 1951-2000 baseline, so that meaningful
use of such scenarios for local contexts requires consideration of a scenario that corresponds
to temperatures in 1975, the central year of this period).
}
\examples{

temperature_scenario_from_records(weather=KA_weather,year=2001,weather_start=2000,weather_end=2005)

 
}
\author{
Eike Luedeling
}
\keyword{utility}
