% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_temperature_record.R
\name{check_temperature_record}
\alias{check_temperature_record}
\title{Check a daily or hourly temperature record for compliance with chillR's standards}
\usage{
check_temperature_record(weather, hourly = FALSE, completeness_check = TRUE,
  no_variable_check = FALSE)
}
\arguments{
\item{weather}{object to be tested for whether it contains chillR-compatible
temperature data.}

\item{hourly}{boolean parameter indicating whether temp_record contains hourly
data. If not, it is assumed to consist of daily records (the default).}

\item{completeness_check}{boolean parameter indicating whether the records should be
checked for completeness.}

\item{no_variable_check}{boolean parameter to indicate whether the function should
check if the dataset contains the usual chillR temperature variables. Defaults to
TRUE, but should be set to FALSE for different data formats.}
}
\value{
list containing the following elements: 'data_frequency' ("daily or "hourly),
'weather_object' (boolean, indicates whether records are in a sub-object called weather),
'chillR_compliant' (boolean, indicates whether the object was found to conform to
chillR format standards) and 'error' (contains error messages generated during the
checking procedure).
}
\description{
This function performs basic tests to determine whether a temperature record
complies with chillR's formatting rules. If desired, the function also checks
whether the record is complete (has rows for all time units in the interval)
and how many values are missing.
}
\note{
This function doesn't check whether there are faulty data. It only tests
whether the data is compatible with the requirements of chillR's major functions.
}
\examples{

check_temperature_record(KA_weather)

}
\references{
The chillR package:

Luedeling E, Kunz A and Blanke M, 2013. Identification of chilling and heat
requirements of cherry trees - a statistical approach. International Journal
of Biometeorology 57,679-689.
}
\author{
Eike Luedeling
}
\keyword{utilities}
