% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Function.R
\name{word_counts}
\alias{word_counts}
\title{Get Word Counts by Speaker Role}
\usage{
word_counts(
  word_list_file,
  output_file,
  collection = NULL,
  language = NULL,
  corpus = NULL,
  age = NULL,
  sex = NULL
)
}
\arguments{
\item{word_list_file}{Path to CSV file with a "word" column.}

\item{output_file}{Path to output Excel (.xlsx) file.}

\item{collection}{Language collection (default = NULL).}

\item{language}{Vector of languages.}

\item{corpus}{Vector of corpora.}

\item{age}{Numeric vector: single value or min/max.}

\item{sex}{"male" and/or "female".}
}
\value{
Writes an Excel file with 2 sheets: word frequencies and summary.
}
\description{
Reads a word list CSV and outputs a word frequency Excel file with summary.
}
\examples{
\donttest{
word_file <- system.file("extdata", "word_list.csv", package = "childeswordfreq")
output_file <- tempfile(fileext = ".xlsx")
word_counts(
  word_list_file = word_file,
  output_file = output_file,
  collection = NULL,
  language = "eng",
  age = c(18, 36),
  sex = NULL
)
}
}
