% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNull.r
\name{checkNull}
\alias{assertNull}
\alias{assert_null}
\alias{checkNull}
\alias{testNull}
\alias{test_null}
\title{Check if an argument is NULL}
\usage{
checkNull(x)

assertNull(x, add = NULL, .var.name = NULL)

assert_null(x, add = NULL, .var.name = NULL)

testNull(x)

test_null(x)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertNull}/\code{assert_null}
 throws an error message, \code{testNull}/\code{test_null}
 returns \code{FALSE},
 and \code{checkNull} returns a string with the error message.
 The function \code{expect_null} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is NULL
}
\examples{
testNull(NULL)
testNull(1)
}

