% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_breaks.R
\name{get_breaks}
\alias{get_breaks}
\alias{get_breaks.default}
\alias{get_breaks.numeric}
\alias{get_breaks.integer64}
\title{Pretty break-points for continuous (numeric) data}
\usage{
get_breaks(x, n = 10, ...)

\method{get_breaks}{default}(x, n = 10, ...)

\method{get_breaks}{numeric}(
  x,
  n = 10,
  pretty = TRUE,
  expand_min = FALSE,
  expand_max = pretty,
  ...
)

\method{get_breaks}{integer64}(x, n = 10, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{n}{Number of breakpoints. You may get less or more than requested.}

\item{...}{Extra arguments passed onto methods.}

\item{pretty}{Should pretty break-points be prioritised? Default is \code{TRUE}.
If \code{FALSE} bin-widths will be calculated as \code{diff(range(x)) / n}.}

\item{expand_min}{Should smallest break be extended beyond the
minimum of the data? Default is \code{FALSE}.
If \code{TRUE} then \code{min(get_breaks(x))} is ensured to be less than \code{min(x)}.}

\item{expand_max}{Should largest break be extended beyond the maximum
of the data? Default is \code{TRUE}.
If \code{TRUE} then \code{max(get_breaks(x))} is ensured
to be greater than \code{max(x)}.}
}
\value{
A numeric vector of break-points.
}
\description{
The distances between break-points are always equal in this implementation.
}
\examples{
library(cheapr)

set.seed(123)
ages <- sample(0:80, 100, TRUE)

# Pretty
get_breaks(ages, n = 10)
# Not-pretty
# bin-width is diff(range(ages)) / n_breaks
get_breaks(ages, n = 10, pretty = FALSE)

# `get_breaks()` is left-biased in a sense, meaning that
# the first break is always <= `min(x)` but the last break
# may be < `max(x)`

# To get right-biased breaks we can use a helper like so..

right_breaks <- function(x, ...){
  -get_breaks(-x, ...)
}

get_breaks(4:24, 10)
right_breaks(4:24, 10)

# Use `rev()` to ensure they are in ascending order
rev(right_breaks(4:24, 10))

}
\seealso{
\link{bin} \link{as_discrete}
}
