% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatRater.R
\name{chatRater-package}
\alias{chatRater-package}
\title{Multi-Model LLM API Wrapper and Cognitive Experiment Utilities}
\description{
This package provides functions to interact with multiple LLM APIs
(e.g., 'OpenAI', 'DeepSeek', 'Anthropic', 'Cohere', 'Google PaLM', 'Ollama').

Additionally, several functions are provided that encapsulate LLM prompts to obtain
various psycholinguistic metrics:
\itemize{
  \item \strong{Word Frequency}: Number of occurrences (often log-transformed) of a word in a corpus.
  \item \strong{Lexical Coverage}: Proportion of words in the stimulus that are found in a target vocabulary.
  \item \strong{Zipf Metric}: The slope of the log-log frequency vs. rank distribution, per Zipf's law.
  \item \strong{Levenshtein Distance (D)}: Minimum number of single-character edits required to transform one stimulus into another.
  \item \strong{Semantic Transparency}: The degree to which the meaning of a compound or phrase is inferable from its parts.
}
}
\details{
The LLM API functions allow users to generate ratings using various large language models.
The cognitive experiment functions.}
