% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkErrorDet.R
\name{checkErrorDet}
\alias{checkErrorDet}
\title{Check Error Details}
\usage{
checkErrorDet(
  input = clipr::read_clip(),
  Summary_nch = 100,
  Model = "gpt-4-0314",
  temperature = 1,
  language = "English",
  verbose = TRUE,
  SlowTone = FALSE
)
}
\arguments{
\item{input}{A string containing the error message to be analyzed, read from the clipboard by default.}

\item{Summary_nch}{An integer specifying the maximum number of characters for the summary.}

\item{Model}{A string specifying the model to be used, default is "gpt-4-0314".}

\item{temperature}{A numeric value for controlling randomness in the output, default is 1.}

\item{language}{A string specifying the output language, default is "English".}

\item{verbose}{A logical value to control the verbosity of the output, default is TRUE.}

\item{SlowTone}{A logical value to control the printing speed of the output, default is FALSE.}
}
\value{
The function prints the guidance on how to fix the error message.
}
\description{
A function to analyze and provide guidance on how to fix an error message copied from the R console.
}
\details{
Check Error Details

This function provides a way to check error details in R. It takes an error message from the R console,
executes the function, and shows how to fix the error in the specified language.
}
\examples{
\dontrun{
  # Copy the error message that you want to fix.
  checkErrorDet()
  checkErrorDet(language = "Japanese")
}
}
\author{
Satoshi Kume
}
