% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_with_missing.R
\name{online.network.missing}
\alias{online.network.missing}
\title{Online change point detection for network data with missing values.}
\usage{
online.network.missing(
  data_incomplete_list,
  eta_list,
  alpha_grid,
  thresholds_array,
  rho_hat,
  pi_ub_hat,
  C_lambda = 2/3,
  delta = 5
)
}
\arguments{
\item{data_incomplete_list}{A \code{list} of adjacency matrices (with entries being 0 or 1) with missing values being coercing to 0.}

\item{eta_list}{A \code{list} of matrices associated with data_incomplete_list, each matrix indicates the missing entries in corresponding adjacency matrix.}

\item{alpha_grid}{A \code{numeric} vector in (0,1) representing the desired false alarm rate.}

\item{thresholds_array}{A \code{numeric} array of calibrated thresholds.}

\item{rho_hat}{A \code{numeric} scalar of the sparsity parameter.}

\item{pi_ub_hat}{A \code{numeric} scalar of the upper bound of the missing probability.}

\item{C_lambda}{A \code{numeric} scalar of an absolute constant, which is set to be 2/3 by default.}

\item{delta}{An \code{integer} scalar of minimum spacing.}
}
\value{
Online change point estimator.
}
\description{
Perform online change point detection for network with missing values by controlling the false alarm rate at level alpha.
}
\references{
Dubey, Xu and Yu (2021) <arxiv:2110.06450>
}
\seealso{
\code{\link{calibrate.online.network.missing}} for calibrating thresholds.
}
\author{
Haotian Xu
}
