% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDPG.R
\name{WBS.nonpar.RDPG}
\alias{WBS.nonpar.RDPG}
\title{Wild binary segmentation for dependent dynamic random dot product graph models.}
\usage{
WBS.nonpar.RDPG(data_mat, lowerdiag = FALSE, d, Alpha, Beta, delta)
}
\arguments{
\item{data_mat}{A \code{numeric} matrix of observations with horizontal axis being time, and vertical axis being vectorized adjacency matrix.}

\item{lowerdiag}{A \code{logic} scalar. TRUE, if each row of data_mat is the vectorization of the strictly lower diagonal elements in an adjacency matrix. FALSE, if each row of data_mat is the vectorization of all elements in an adjacency matrix.}

\item{d}{A \code{numeric} scalar of the number of leading singular values of an adjacency matrix considered in the scaled PCA algorithm.}

\item{Alpha}{A \code{integer} vector of starting indices of random intervals.}

\item{Beta}{A \code{integer} vector of ending indices of random intervals.}

\item{delta}{A positive \code{integer} scalar of minimum spacing.}
}
\value{
An object of \code{\link[base]{class}} "BS", which is a \code{list} with the following structure:
 \item{S}{A vector of estimated change point locations (sorted in strictly increasing order).}
 \item{Dval}{A vector of values of CUSUM statistic.}
 \item{Level}{A vector representing the levels at which each change point is detected.}
 \item{Parent}{A matrix with the starting indices on the first row and the ending indices on the second row.}
}
\description{
Perform wild binary segmentation for dependent dynamic random dot product graph models.
}
\examples{
### generate data 
p = 20 # number of nodes
n = 50 # sample size for each segment
lat_dim_num = 5 # number of latent dimensions
set.seed(1)
x_mat = matrix(runif(p*lat_dim_num), nrow = p, ncol = lat_dim_num)
x_tilde_mat = matrix(runif(p*lat_dim_num), nrow = p, ncol = lat_dim_num)
y_mat = rbind(x_tilde_mat[1:floor(p/4),], x_mat[(floor(p/4)+1):p,])
rdpg1 = simu.RDPG(x_mat, n, symm = TRUE, self = FALSE)
rdpg2 = simu.RDPG(y_mat, n, symm = TRUE, self = FALSE)
data1_mat = rdpg1$obs_mat
data2_mat = rdpg2$obs_mat
data_mat = cbind(data1_mat, data2_mat)
### detect change points
M = 30 # number of random intervals for WBS
d = 10 # parameter for scaled PCA algorithm
delta = 5
intervals = WBS.intervals(M = M, lower = 1, upper = ncol(data_mat))
WBS_result = WBS.nonpar.RDPG(data_mat, lowerdiag = TRUE, d, 
             Alpha = intervals$Alpha, Beta = intervals$Beta, delta)
}
\references{
Padilla, Yu and Priebe (2019) <arxiv:1911.07494>.
}
\seealso{
\code{\link{thresholdBS}} for obtaining change points estimation, \code{\link{tuneBSnonparRDPG}} for a tuning version.
}
\author{
Oscar Hernan Madrid Padilla, Haotian Xu
}
