% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg_const}
\alias{cg_const}
\title{Add Constant}
\arguments{
\item{value}{numeric vector or array, value of the node (optional).}

\item{name}{character scalar, name of the node (optional). In case argument \code{name} is missing, the node is tried to be added to the graph under an auto-generated name.}
}
\value{
cg_node, constant.
}
\description{
Add a constant node to the graph.
}
\details{
\code{$const(value = NULL, name = NULL)}
}
\note{
Constants are ignored when differentiating a graph. The intended use of constants is that they are given a fixed value. However, it is still possible to change the value of constants when evaluating or differentiating a graph (see \link[cgraph]{cg_run} and \link[cgraph]{cg_gradients} for more details).

There is a wrapper function \link[cgraph]{const} that calls this method on the current active graph.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add a constant with value 1 and name 'c' to the graph.
x$const(1, name = "c")

}
\author{
Ron Triepels
}
