% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{opr}
\alias{opr}
\title{Add Operation}
\usage{
opr(call, grads, args, name = NULL)
}
\arguments{
\item{call}{symbol, operation performed by the node.}

\item{grads}{list of symbols, gradients functions of the input nodes that are consumed by the operation in argument \code{call}.}

\item{args}{list of cg_node objects, the nodes that are consumed by the operation in argument \code{call}.}

\item{name}{character scalar, name of the node (optional). In case argument \code{name} is missing, the node is tried to be added to the graph under an auto-generated name.}
}
\value{
cg_node, operation.
}
\description{
Add an operation node to the active graph.
}
\note{
The operation to be performed by the node should be provided as a symbol to argument \code{call}. If this operation consumes any other nodes in the graph, then the gradient function of the operation with respect to these input nodes should be supplied as a symbol to argument \code{gradients}. These gradients must be a function of each input's gradient. A gradient function must be provided for each input node as specified by argument \code{args}.
}
\author{
Ron Triepels
}
