# cgalMeshes

R6 based utilities for 3D meshes.

<!-- badges: start -->
[![R-CMD-check](https://github.com/stla/cgalMeshes/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/stla/cgalMeshes/actions/workflows/R-CMD-check.yaml)
[![R-CMD-check-valgrind](https://github.com/stla/cgalMeshes/actions/workflows/R-CMD-check-valgrind.yaml/badge.svg)](https://github.com/stla/cgalMeshes/actions/workflows/R-CMD-check-valgrind.yaml)
<!-- badges: end -->


### Geodesic distance 

![](https://raw.githubusercontent.com/stla/cgalMeshes/main/inst/screenshots/trefoilKnot.gif)

![](https://raw.githubusercontent.com/stla/cgalMeshes/main/inst/screenshots/knot-2-5.gif)

![](https://raw.githubusercontent.com/stla/cgalMeshes/main/inst/screenshots/dragon.png)


### Clipping

![](https://raw.githubusercontent.com/stla/MeshesTools/main/inst/screenshots/Togliatti.gif)


### Fairing

![](https://raw.githubusercontent.com/stla/cgalMeshes/main/inst/screenshots/HopfTorus.gif)


### Decomposition into convex parts

![](https://raw.githubusercontent.com/stla/MeshesOperations/master/inst/screenshots/pentagrammicPrism.png)


### Boolean operations

#### Intersection

![](https://raw.githubusercontent.com/stla/MeshesOperations/master/inst/screenshots/Intersection.png)

![](https://laustep.github.io/stlahblog/posts/figures/tetrahedraCompoundIntersection.gif)

#### Difference

![](https://raw.githubusercontent.com/stla/MeshesOperations/master/inst/screenshots/Difference.png)

#### Union

![](https://raw.githubusercontent.com/stla/MeshesOperations/master/inst/screenshots/Union.png)

![](https://raw.githubusercontent.com/stla/MeshesOperations/master/inst/screenshots/tetrahedraCompound.gif)


### Advanced front surface reconstruction

*Stanford bunny:*

![](https://raw.githubusercontent.com/stla/SurfaceReconstruction/master/inst/AFSexamples/Bunny.png)

*Stanford dragon:*

![](https://raw.githubusercontent.com/stla/SurfaceReconstruction/master/inst/AFSexamples/StanfordDragon.png)

*Dummy head:*

![](https://raw.githubusercontent.com/stla/SurfaceReconstruction/master/inst/AFSexamples/DummyHead.png)

*Skull:*

![](https://raw.githubusercontent.com/stla/SurfaceReconstruction/master/inst/AFSexamples/Skull.png)


### Other tools

Volume, area, centroid, distance between a point and a mesh, connected 
components.


### Blog post

['CGAL' meets 'R6': the 'cgalMeshes' package](https://laustep.github.io/stlahblog/posts/cgalMeshes.html)



## License

This package is provided under the GPL-3 license but it uses the C++ library 
CGAL. If you wish to use CGAL for commercial purposes, you must obtain a 
license from the [GeometryFactory](https://geometryfactory.com).
