% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_recruiting.R
\name{cfbd_recruiting_team}
\alias{cfbd_recruiting_team}
\title{\strong{Get college football recruiting team rankings information.}}
\usage{
cfbd_recruiting_team(year = NULL, team = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Recruiting Class Year, 4 digit format (\emph{YYYY}). \emph{Note: 2000 is the minimum value}}

\item{team}{(\emph{String} optional): Team - Select a valid team, D1 football}
}
\value{
\code{\link[=cfbd_recruiting_team]{cfbd_recruiting_team()}} - A data frame with 4 variables:
\describe{
\item{\code{year}: integer.}{Recruiting class year.}
\item{\code{rank}: integer.}{Team Recruiting rank.}
\item{\code{team}: character.}{Recruiting Team.}
\item{\code{points}: character.}{Team talent points.}
}
}
\description{
\strong{Get college football recruiting team rankings information.}
}
\examples{
\donttest{
cfbd_recruiting_team(2018, team = "Texas")

cfbd_recruiting_team(2016, team = "Virginia")

cfbd_recruiting_team(2016, team = "Texas A&M")

cfbd_recruiting_team(2011)
}

}
\keyword{Recruiting}
