% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpreview.R
\name{get_preview}
\alias{get_preview}
\title{Create a preview dataframe object of a CES survey.}
\usage{
get_preview(srvy, obs = 6, pos = 1)
}
\arguments{
\item{srvy}{A CES survey code call. See \emph{Survey Code Calls} below.
\code{srvy} value must be a character string.}

\item{obs}{A numerical value that determines the number of observations returned.
If a value for \code{obs} is not given, then default value is 6 observations.
Variable must be given as a numerical value.}

\item{pos}{Environment assignment. Defaults to 1, which is an assignment to the global environment.}
}
\value{
The truncated version of the requested survey dataset \code{srvy} with the set number of observations \code{obs}
to the designated environment \code{pos}.
}
\description{
\code{get_preview()} creates a truncated dataframe for a requested Canadian Election Study
survey using an associated code to call and download
the survey dataset.
}
\details{
\subsection{Datasets}{

Datasets are loaded using either .dta or .sav file types
and converted to factor type using the \code{to_factor()} function
from the \code{labelled} package.
}

\subsection{Survey Code Calls}{

\code{get_preview()} uses the same survey code calls as the \code{get_ces()} function.
These survey code calls are listed below.
\itemize{
\item \code{ces2019_web} calls 2019 CES online survey dataset.
\item \code{ces2019_phone} calls 2019 CES phone survey dataset.
\item \code{ces2015_web} calls 2015 CES online survey dataset.
\item \code{ces2015_phone} calls 2015 CES phone survey dataset.
\item \code{ces2015_combo} calls 2015 CES combined (online/phone) dataset.
\item \code{ces2011} calls 2011 CES survey dataset.
\item \code{ces2008} calls 2008 CES survey dataset.
\item \code{ces2004} calls 2004 CES survey dataset.
\item \code{ces0411} calls 2004-2011 CES survey dataset.
\item \code{ces0406} calls 2004-2006 CES survey dataset.
\item \code{ces2000} calls 2000 CES survey dataset.
\item \code{ces1997} calls 1997 CES survey dataset.
\item \code{ces1993} calls 1993 CES survey dataset.
\item \code{ces1988} calls 1988 CES survey dataset.
\item \code{ces1984} calls 1984 CES survey dataset.
\item \code{ces1974} calls 1974 CES survey dataset.
\item \code{ces7480} calls 1974-1980 CES survey dataset.
\item \code{ces72_jnjl} calls 1972 June-July CES survey dataset.
\item \code{ces72_sep} calls 1972 September CES survey dataset.
\item \code{ces72_nov} calls 1972 November CES survey dataset.
\item \code{ces1968} calls 1968 CES survey dataset.
\item \code{ces1965} calls 1965 CES survey dataset.
}
}

\subsection{Incorrect/Repeated Code Calls}{

Incorrect (a non-existent survey code) will stop the function process and return associated error messages.
Repeated code calls will load in an unaltered version of the requested table.
}

\subsection{Extra Notes}{

Due to the naming of the columns in the 1965 and 1968 datasets it is recommended
to download the associated codebook for the requested dataset.
}
}
\examples{
\dontrun{
# print out CES call codes
get_cescodes()

# call the 1993 CES dataset
get_ces("ces1993")

# preview the first 10 observations of the dataset
get_preview("ces1993", 10)
}

}
\seealso{
\code{get_ces()} function help.
\code{get_cescodes()} function help.
}
