% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-tracks.R
\name{simulateTracks}
\alias{simulateTracks}
\title{Generate Tracks by Simulation}
\usage{
simulateTracks(n, expr)
}
\arguments{
\item{n}{number of tracks to be generated.}

\item{expr}{the expression, usually a call, that generates a single track.}
}
\value{
A \code{tracks} object containing \code{n} tracks.
}
\description{
Generic function that executes \code{expr}, which is expected to
return a track, \code{n} times and stores the output in a \code{tracks}
object. Basically, this works like \code{\link{replicate}} but for tracks.
}
\examples{
## Generate 10 tracks, 100 steps each, from a random walk with standard normally
## distributed increments and plot them
plot( simulateTracks( 10, brownianTrack(100,3) ) )

}
