% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrStart.R
\name{qrStart}
\alias{qrStart}
\title{Starting Value Generation for CDF quantile Regressions}
\usage{
qrStart(ydata, fd = NULL, sd = NULL, skew = FALSE)
}
\arguments{
\item{ydata}{The variable to be modeled}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the sub-family distribution.}

\item{skew}{If ture, the starting values will be generated for the finited tailed distribution case.}
}
\value{
A vector that consists initial values for mu and sigma.
}
\description{
\code{qrStart} is the function for generating starting values for a cdf-quantile GLM null model.
}
\details{
The start values for the location parameter in a null model are 
the median of the empirical distribution, and a starting value for the dispersion parameter based on a 
specific quantile of the empirical distribution, specified according to the theoretical distribution
on which the model is based.
The start values for all new predictor coefficients in both the location and dispersion 
submodels are assigned the value 0.1.
}
\examples{
x <- rbeta(100, 1, 2)
qrStart(x, fd='t2', sd='t2')
#[1] -0.5938286  1.3996999
}
