% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfquantregCensor.R
\name{cdfquantregC}
\alias{cdfquantregC}
\title{Censored CDF-Quantile Probability Distributions}
\usage{
cdfquantregC(formula, fd = NULL, sd = NULL, data, family = NULL,
  censor = "DB", c1 = NULL, c2 = NULL, start = NULL,
  control = cdfqr.control(...), ...)
}
\arguments{
\item{formula}{A formula object, with the dependent variable (DV) on the left of an ~ operator, and predictors on the right. For the part on the right of '~', the specification of the location and dispersion submodels can be separated by '|'. So \code{y ~ X1 | X2} specifies that the DV is \code{y}, \code{X1} is the predictor in the location submodel, and \code{X2} is the predictor in the dispersion submodel.}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the child distribution.}

\item{data}{The data in a data.frame format}

\item{family}{If `fd` and `sd` are not provided, the name of a member of the family of distributions can be provided (See \code{\link{cdfqrFamily}} for details of family functions)}

\item{censor}{A string variable to indicate how many censored point is used- only left censored \code{`LC`}, or only right-hand censored \code{`RC`}, or both sides \code{`DB`}.}

\item{c1}{The left censored value, if NULL, the minimum value in the data will be used}

\item{c2}{The right censored value, if NULL, the maximum value in the data will be used}

\item{start}{The starting values for model fitting. If not provided, default values will be used.}

\item{control}{Control optimization parameters  (See \code{\link{cdfqr.control}}))}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{cdfquantreg} will be returned. Generic functions such as \link{summary},\link{print} (e.g.,  \link{print.cdfqr}) and \link{coef} can be used to extract output (see \link{summary.cdfqr} for more details about the generic functions that can be used).
Class of object is a list with the following output:
 \describe{
  \item{coefficients}{A named vector of coefficients.}
  \item{residuals}{Raw residuals, the difference between the fitted values and the data.}
  \item{fitted}{The fitted values, including full model fitted values, fitted values for the mean component, and fitted values for the dispersion component.}
  \item{rmse}{The model root mean squared errors}
  \item{rmseLogit}{The root mean squared errors between the logit of the fitted values, and the logit of the response values.}
  \item{vcov}{The variance-covariance matrix of the coefficient estimates.}
  \item{AIC, BIC}{Akaike's Information Criterion and Bayesian Information Criterion.}
  \item{deviance}{The deviance for the model.}
}
}
\description{
\code{cdfquantregC} is the a function to fit a censored cdf quantile regression with a variety of distributions .
}
\details{
The cdfquantreg function fits a quantile regression model with a distributions from the cdf-quantile family selected by the user (Smithson and Shou, 2015). The model is specified in a two-part formula, one part containing the predictors of the location parameter, and the second part containing the predictors of the dispersion parameter.  The models are fitted in two stages, the first of which uses the Nelder-Mead algorithm and the second of which takes the estimates from the first stage and applies the BFGS algorithm to refine the estimates.
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantregC(crc99 ~ vert | confl, c1 = 0.001, c2= 0.999, 
fd ='t2',sd ='t2', data = JurorData)

summary(fit)
}
