% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValeMorelli.r
\name{FleishmanIC}
\alias{FleishmanIC}
\title{Functions to generate nonnormal distributed multivariate random vectors with mean=0, var=1 and  given correlations and coefficients of skewness
  and excess kurtosis. This is done with the method of Vale & Morelli: The coefficients of the Fleishman transform Y = -c  + bX +cX^2 + dX^3 are computed.
  from given skewness gamma[1] = E(Y^3) and kurtosis gamma[2] = E(Y^4) - 3. A indermediate correlation matrix is computed from the desired correlation 
  matrix and the Fleishman coefficients. A singular value decomposition of the indermediate correlation matrix is performed and  a matrix of independend 
  normal random numbers is generated and transformed into correlated ones. Finally the Fleishman transform is applied to the columns of this data matrix.}
\usage{
FleishmanIC(skew, kurt)
}
\arguments{
\item{skew}{desired skewness}

\item{kurt}{desired kurtosis}
}
\value{
par vector with coefficients b,c,d
}
\description{
The function are adapted from online support of the SAS system,
  URL: support.sas.com/publishing/authors/extras/65378_Appendix_D_Functions_for_Simulating_Data_by_Using_Fleishmans_Transformation.pdf
\code{FleishmanIC} produce an initial guess of the Fleishman coefficients from given skewness and kurtosis. It is to use for Newton's algorithm. 
 This guess is produced by a polynomial regression.
}
\examples{
out <- FleishmanIC(1,2)

}
