% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caviarpd.R
\name{caviarpd}
\alias{caviarpd}
\title{Cluster Analysis via Random Partition Distributions}
\usage{
caviarpd(
  distance,
  nClusters,
  mass = NULL,
  nSamples = 200,
  gridLength = 5,
  loss = "binder",
  temperature = 100,
  similarity = c("exponential", "reciprocal")[1],
  maxNClusters = 0,
  nRuns = 4,
  nCores = nRuns
)
}
\arguments{
\item{distance}{An object of class 'dist' or a pairwise distance matrix.}

\item{nClusters}{A numeric vector that specifies the range for the number of clusters to consider in the search for a clustering estimate.}

\item{mass}{The mass value to use for sampling. If \code{NULL}, the mass value is found by inverting values from \code{nClusters}.}

\item{nSamples}{The number of samples drawn per candidate estimate.}

\item{gridLength}{The number of candidate estimates to consider. The final estimate is obtained from \code{nSamples} \eqn{\times} \code{gridLength} total samples.}

\item{loss}{The SALSO method (Dahl, Johnson, Müller, 2021) tries to minimize this expected loss when searching the partition space for an optimal estimate. This must be either "binder" or "VI".}

\item{temperature}{A positive number that accentuates or dampens distance between observations.}

\item{similarity}{Either \code{"exponential"} or \code{"reciprocal"} to indicate the desired similarity function.}

\item{maxNClusters}{The maximum number of clusters that can be considered by the SALSO method.}

\item{nRuns}{The number of runs of the SALSO algorithm.}

\item{nCores}{The number of CPU cores to use. A value of zero indicates to use all cores on the system.}
}
\value{
A object of class \code{salso.estimate}, which provides a clustering estimate (a vector of cluster labels) that can be displayed and plotted.
}
\description{
Returns a clustering estimate given pairwise distances using the CaviarPD method.
}
\details{
A range for the number of clusters to be considered is supplied using the
\code{nClusters} argument.
}
\examples{
# To reduce load on CRAN servers, limit the number of samples, grid length, and CPU cores.
set.seed(34)
iris.dis <- dist(iris[,-5])
est <- caviarpd(distance=iris.dis, nClusters=c(2,4), nSamples=20, nCores=1)
if ( require("salso") ) {
  summ <- summary(est, orderingMethod=2)
  plot(summ, type="heatmap")
  plot(summ, type="mds")
}

}
\references{
D. B. Dahl, J. Andros, J. B. Carter (2022+), Cluster Analysis via Random Partition
Distributions, \emph{Statistical Analysis and Data Mining}, accepted.
\doi{10.1002/sam.11602}.

D. B. Dahl, D. J. Johnson, and P. Müller (2022), Search Algorithms and Loss
Functions for Bayesian Clustering, \emph{Journal of Computational and
Graphical Statistics}, \doi{10.1080/10618600.2022.2069779}.
'
}
