% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatDML.R
\name{treatDML}
\alias{treatDML}
\title{Binary or multiple  discrete treatment effect evaluation with double machine learning}
\usage{
treatDML(
  y,
  d,
  x,
  s = NULL,
  dtreat = 1,
  dcontrol = 0,
  trim = 0.01,
  MLmethod = "lasso",
  k = 3,
  normalized = TRUE
)
}
\arguments{
\item{y}{Dependent variable, must not contain missings.}

\item{d}{Treatment variable, must be discrete, must not contain missings.}

\item{x}{Covariates, must not contain missings.}

\item{s}{Indicator function for defining a subpopulation for whom the treatment effect is estimated as a function of the subpopulation's distribution of \code{x}. Default is \code{NULL} (estimation of the average treatment effect in the total population).}

\item{dtreat}{Value of the treatment in the treatment group. Default is 1.}

\item{dcontrol}{Value of the treatment in the control group. Default is 0.}

\item{trim}{Trimming rule for discarding observations with treatment propensity scores that are smaller than \code{trim} or larger than \code{1-trim} (to avoid too small denominators in weighting by the inverse of the propensity scores). Default is 0.01.}

\item{MLmethod}{Machine learning method for estimating the nuisance parameters based on the \code{SuperLearner} package. Must be either  \code{"lasso"} (default) for lasso estimation,  \code{"randomforest"} for random forests, \code{"xgboost"} for xg boosting,  \code{"svm"} for support vector machines, \code{"ensemble"} for using an ensemble algorithm based on all previously mentioned machine learners, or \code{"parametric"} for linear or logit regression.}

\item{k}{Number of folds in k-fold cross-fitting. Default is 3.}

\item{normalized}{If set to \code{TRUE}, then the inverse probability-based weights are normalized such that they add up to 1 within treatment groups. Default is \code{TRUE}.}
}
\value{
A \code{treatDML} object contains eight components, \code{effect}, \code{se}, \code{pval}, \code{ntrimmed}, \code{meantreat}, \code{meancontrol}, \code{pstreat}, and \code{pscontrol}:

\code{effect}: estimate of the average treatment effect.

\code{se}: standard error of the effect.

\code{pval}: p-value of the effect estimate.

\code{ntrimmed}: number of discarded (trimmed) observations due to extreme propensity scores.

\code{meantreat}: Estimate of the mean potential outcome under treatment.

\code{meancontrol}: Estimate of the mean potential outcome under control.

\code{pstreat}: P-score estimates for treatment in treatment group.

\code{pscontrol}: P-score estimates for treatment in control group.
}
\description{
Treatment effect estimation for assessing the average effects of discrete (multiple or binary) treatments. Combines estimation based on (doubly robust) efficient score functions with double machine learning to control for confounders in a data-driven way.
}
\details{
Estimation of the causal effects of binary or multiple discrete treatments under conditional independence, assuming that confounders jointly affecting the treatment and the outcome can be controlled for by observed covariates. Estimation is based on the (doubly robust) efficient score functions for potential outcomes in combination with double machine learning with cross-fitting, see Chernozhukov et al (2018). To this end, one part of the data is used for estimating the model parameters of the treatment and outcome equations based machine learning. The other part of the data is used for predicting the efficient score functions. The roles of the data parts are swapped (using k-fold cross-fitting) and the average treatment effect is estimated based on averaging the predicted efficient score functions in the total sample.
Standard errors are based on asymptotic approximations using the estimated variance of the (estimated) efficient score functions.
}
\examples{
# A little example with simulated data (2000 observations)
\dontrun{
n=2000                            # sample size
p=100                             # number of covariates
s=2                               # number of covariates that are confounders
x=matrix(rnorm(n*p),ncol=p)       # covariate matrix
beta=c(rep(0.25,s), rep(0,p-s))   # coefficients determining degree of confounding
d=(x\%*\%beta+rnorm(n)>0)*1         # treatment equation
y=x\%*\%beta+0.5*d+rnorm(n)       # outcome equation
# The true ATE is equal to 0.5
output=treatDML(y,d,x)
cat("ATE: ",round(c(output$effect),3),", standard error: ",
    round(c(output$se),3), ", p-value: ",round(c(output$pval),3))
output$ntrimmed}
}
\references{
Chernozhukov, V., Chetverikov, D., Demirer, M., Duflo, E., Hansen, C., Newey, W., Robins, J. (2018): "Double/debiased machine learning for treatment and structural parameters", The Econometrics Journal, 21, C1-C68.

van der Laan, M., Polley, E., Hubbard, A. (2007): "Super Learner", Statistical Applications in Genetics and Molecular Biology, 6.
}
