% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ismw_est.R
\name{ismw_est}
\alias{ismw_est}
\title{The inverse second moment weighting (ismw) method}
\usage{
ismw_est(Y,
         treat,
         data,
         e_treat_1,
         e_treat_2,
         e_treat_3,
         e_treat_4,
         degree )
}
\arguments{
\item{Y}{is the the name of the outcome variable contained in \code{data}.}

\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{data}{is a dataframe containing \code{Y}, \code{treat}, and
\code{X}.}

\item{e_treat_1}{a vector, representing the conditional expectation of
\code{treat} from \code{t_mod}.}

\item{e_treat_2}{a vector, representing the conditional expectation of
\code{treat^2} from \code{t_mod}.}

\item{e_treat_3}{a vector, representing the conditional expectation of
\code{treat^3} from \code{t_mod}.}

\item{e_treat_4}{a vector, representing the conditional expectation of
\code{treat^4} from \code{t_mod}.}

\item{degree}{is 1 for linear and 2 for quadratic outcome model.}
}
\value{
\code{ismw_est} returns an object of class "causaldrf_simple",
a list that contains the following components:
\item{param}{the estimated parameters.}
\item{call}{the matched call.}
}
\description{
This method estimates the ADRF by using weighting matrices instead of
scalars.  The weight matrices require conditional expectations of the
treatment and higher order conditional expectations. It uses outputs from
the \code{t_mod} function.
}
\details{
This function uses the outputs of the t_mod function as inputs.
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data

t_mod_list <- t_mod(treat = T,
                treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                data = example_data,
                treat_mod = "Normal")

cond_exp_data <- t_mod_list$T_data

full_data <- cbind(example_data, cond_exp_data)

ismw_list <- ismw_est(Y = Y,
                      treat = T,
                      data = full_data,
                      e_treat_1 = full_data$est_treat,
                      e_treat_2 = full_data$est_treat_sq,
                      e_treat_3 = full_data$est_treat_cube,
                      e_treat_4 = full_data$est_treat_quartic,
                      degree = 1)

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
      example_data$Y[sample_index],
      xlab = "T",
      ylab = "Y",
      main = "ismw estimate")

abline(ismw_list$param[1],
ismw_list$param[2],
        lty=2,
        lwd = 2,
        col = "blue")

legend('bottomright',
        "ismw estimate",
        lty=2,
        lwd = 2,
        col = "blue",
        bty='Y',
        cex=1)

rm(example_data, t_mod_list, cond_exp_data, full_data, ismw_list, sample_index)

## Example from Hirano & Imbens (2004).
  ## Put example here....
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.
}
\seealso{
\code{\link{iptw_est}}, \code{\link{ismw_est}},
 \code{\link{reg_est}}, \code{\link{aipwee_est}}, \code{\link{wtrg_est}},
   etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

