% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim_class.R
\name{Hainmueller}
\alias{Hainmueller}
\title{Hainmueller data example}
\value{
An \link[R6:R6Class]{R6} object of class \link{DataSim}
}
\description{
Hainmueller data example

Hainmueller data example
}
\details{
Generates the data as described in Hainmueller (2012).
}
\examples{

## ------------------------------------------------
## Method `Hainmueller$new`
## ------------------------------------------------

data <- Hainmueller$new(n = 100, p = 6, design = "A", overlap = "low")
data$gen_data()
print(data$get_x()[1:2,])
}
\section{Super class}{
\code{\link[causalOT:DataSim]{causalOT::DataSim}} -> \code{Hainmueller}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Hainmueller-gen_data}{\code{Hainmueller$gen_data()}}
\item \href{#method-Hainmueller-gen_x}{\code{Hainmueller$gen_x()}}
\item \href{#method-Hainmueller-gen_y}{\code{Hainmueller$gen_y()}}
\item \href{#method-Hainmueller-gen_z}{\code{Hainmueller$gen_z()}}
\item \href{#method-Hainmueller-new}{\code{Hainmueller$new()}}
\item \href{#method-Hainmueller-get_design}{\code{Hainmueller$get_design()}}
\item \href{#method-Hainmueller-get_pscore}{\code{Hainmueller$get_pscore()}}
\item \href{#method-Hainmueller-clone}{\code{Hainmueller$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_n"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_n'><code>causalOT::DataSim$get_n()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_p"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_p'><code>causalOT::DataSim$get_p()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_tau"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_tau'><code>causalOT::DataSim$get_tau()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_x'><code>causalOT::DataSim$get_x()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x0"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_x0'><code>causalOT::DataSim$get_x0()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x1"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_x1'><code>causalOT::DataSim$get_x1()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_y"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_y'><code>causalOT::DataSim$get_y()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_z"><a href='../../causalOT/html/DataSim.html#method-DataSim-get_z'><code>causalOT::DataSim$get_z()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="opt_weight"><a href='../../causalOT/html/DataSim.html#method-DataSim-opt_weight'><code>causalOT::DataSim$opt_weight()</code></a></span></li>
<li><span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="opt_weight_dist"><a href='../../causalOT/html/DataSim.html#method-DataSim-opt_weight_dist'><code>causalOT::DataSim$opt_weight_dist()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-gen_data"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-gen_data}{}}}
\subsection{Method \code{gen_data()}}{
Generates the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$gen_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-gen_x"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-gen_x}{}}}
\subsection{Method \code{gen_x()}}{
Generates the covaraiate data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$gen_x()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-gen_y"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-gen_y}{}}}
\subsection{Method \code{gen_y()}}{
Generates the outcome data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$gen_y()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-gen_z"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-gen_z}{}}}
\subsection{Method \code{gen_z()}}{
Generates the treatment indicator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$gen_z()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-new"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-new}{}}}
\subsection{Method \code{new()}}{
Generates the the Hainmueller \code{R6} class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$new(
  n = 100,
  p = 6,
  param = list(),
  design = "A",
  overlap = "low",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{The number of observations}

\item{\code{p}}{The dimensions of the covariates.
Fixed to 6.}

\item{\code{param}}{The data generating parameters
fed as a list.}

\item{\code{design}}{One of "A" or "B". See details.}

\item{\code{overlap}}{One of "high", "low", or "medium".
See details.}

\item{\code{...}}{Extra arguments. Currently unused.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\subsection{Design}{

Design "A"
is the setting where the outcome is generated
from a linear model,
\eqn{Y(0) = Y(1) = X_1 + X_2 + X_3 - X_4 + X_5 + X_6 + \eta}
and design "B" is where the outcome is
generated from the non-linear model
\eqn{Y(0) = Y(1) = (X_1 + X_2 +X_5 )^2 + \eta}.
}

\subsection{Overlap}{

The treatment indicator is generated from
\eqn{Z = 1(X_1 + 2 X_2 - 2 X_3 - X_4 - 0.5 X_5 + X_6 + \nu > 0)}, where \eqn{\nu}
depends on the overlap selected. If overlap is "high",
then \eqn{\nu \sim N(0, 100).} If overlap is
"low", then \eqn{\nu \sim N(0, 30).} Finally,
if overlap is "medium", then \eqn{\nu} is drawn
from a \eqn{\chi^2} with 5 degrees of freedom
that is scaled and centered to have mean 0.5 and
variance 67.6.
}
}

\subsection{Returns}{
An object of class \link{DataSim}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data <- Hainmueller$new(n = 100, p = 6, design = "A", overlap = "low")
data$gen_data()
print(data$get_x()[1:2,])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-get_design"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-get_design}{}}}
\subsection{Method \code{get_design()}}{
Returns the chosen design parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$get_design()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-get_pscore"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-get_pscore}{}}}
\subsection{Method \code{get_pscore()}}{
Returns the true propensity score
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$get_pscore()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Hainmueller-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Hainmueller-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hainmueller$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
