test_that("diagrammer object can be created", {
  renderGraph = dag_create() %>%
    dag_node("# of Hot Day Beachgoers") %>%
    dag_node(c("Rent by Location",
               "Beachgoer Location Probability"),
             obs = TRUE) %>%
    dag_node(c("Revenue","Expenses","Profit"),
             det = TRUE) %>%
    dag_node("Bathhouse Location",
             dec = TRUE) %>%
    dag_edge(from = c("# of Hot Day Beachgoers",
                      "Beachgoer Location Probability",
                      "Bathhouse Location"),
             to = "Revenue") %>%
    dag_edge(from = c("Bathhouse Location",
                      "Rent by Location"),
             to = "Expenses") %>%
    dag_edge(from = c("Revenue","Expenses"),
             to = "Profit") %>%
    dag_diagrammer()
  expect_type(renderGraph, "list")
})
