% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.R
\name{top_pairs}
\alias{top_pairs}
\title{Calculate the top scagnostic for each pair of variables}
\usage{
top_pairs(scags_data)
}
\arguments{
\item{scags_data}{A dataset of scagnostic values that was returned by calc_scags or calc_scags_wide}
}
\value{
A data frame where each row is a each scatter plot, its highest valued scagnostic, and its respective value
}
\description{
Calculate the top scagnostic for each pair of variables
}
\examples{
#an example using calc_scags
require(dplyr)
datasaurus_dozen \%>\%
  group_by(dataset) \%>\%
  summarise(calc_scags(x,y, scags=c("monotonic", "outlying", "convex"))) \%>\%
  top_pairs()
 #an example using calc_scags_wide
 data(pk)
 scags_data <- calc_scags_wide(pk[,2:5], scags=c("outlying","clumpy","monotonic"))
 top_pairs(scags_data)
}
\seealso{
calc_scags calc_scags_wide top_scags
}
