% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.absRiskCB}
\alias{confint.absRiskCB}
\title{Compute confidence intervals for risks}
\usage{
\method{confint}{absRiskCB}(object, parm, level = 0.95, nboot = 500, ...)
}
\arguments{
\item{object}{Output of function \code{absoluteRisk}.}

\item{parm}{Output of function \code{fitSmoothHazard} that was used to
compute \code{object}.}

\item{level}{The confidence level required.}

\item{nboot}{The number of bootstrap samples to use.}

\item{...}{Additional arguments for methods.}
}
\value{
If there is only one covariate profile, the function returns a matrix
with the time points, the risk estimates, and the confidence intervals. If
there are more than one covariate profile, the function returns a list with
three components.
}
\description{
This function uses parametric bootstrap to compute confidence intervals for
the risk estimates. Since it relies on MLE theory for the validity of these
intervals, this function only works for \code{fit_obj} that was fitted using
\code{family = "glm"} (i.e. the default).
}
\details{
If the package \code{progress} is available, the function also reports on
progress of the sampling (which can take some time if there are many
covariate profiles and/or time points).
}
