% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowtype.R
\name{flowtype}
\alias{flowtype}
\title{Compute flowdata types (volum, balance)}
\usage{
flowtype(tab, format, x)
}
\arguments{
\item{tab}{is the input flow dataset}

\item{format}{specify the flow dataset format, "M " for square matrix [n*n] or L for long [i,j,data]}

\item{x}{enter the computation type : "flux", "transpose", "bivolum" and "bisold".}
}
\description{
Compute gross (volumn) and net (balance) flows from initial asymetric flow values
}
\details{
The matrice must be squared (if not, see \link{flowcarre}).
This function compute for all pairs or origin-destination places (i,j)
involved in an asymetric flow matrix (Fij<> Fji) several matrix :\cr
- x = "flux" for remaining initial flow (Fij)\cr
- x = "transpose" for reverse flow value (Fji)\cr
- x = "bivolum" for bilateral gross flow Vij=(Fij+Fji)\cr
- x = "bisold" for bilateral net flow Sij=(Fij-Fji) \cr
}
\examples{
library(cartograflow)
data(flowdata)
bkg <- system.file("shape/MGP_TER.shp",
  package = "cartograflow",
  lib.loc = NULL, mustWork = TRUE
)

## 1a:Computes flowtypes: Matrice format
matflow <- flowtabmat(flows, matlist = "M")
m <- flowtype(matflow, format = "M", x = "flux")
m <- flowtype(matflow, format = "M", x = "transpose")
m <- flowtype(matflow, format = "M", x = "bivolum")
m <- flowtype(matflow, format = "M", x = "bisold")

## 1b:Computes flowtypes: Long format
list <- flowtabmat(matflow, matlist = "L")
colnames(list) <- c("i", "j", "Fij")
l_all <- flowtype(list, format = "L", x = "all")
l_sold <- flowtype(list, format = "L", x = "bisold")
\donttest{
# 2:flowmapping: example of bisold
flowmap(l_sold,
  format = "L", bkg, code = "EPT_NUM",
  filter = TRUE, threshold = 20, taille = 5
)
}
}
\references{
Bahoken Francoise, 2016, L'approche cartographique de la décomposition des matrices de flux,
Mappemonde, Revue sur l'image géographique et les formes du territoire,
number 116, URL : https://mappemonde-archive.mgm.fr/num44/articles/art14404.html
}
