% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretList.R
\name{caretList}
\alias{caretList}
\title{Create a list of several train models from the caret package
Build a list of train objects suitable for ensembling using the \code{\link{caretEnsemble}}
function.}
\usage{
caretList(..., trControl = NULL, methodList = NULL, tuneList = NULL,
  continue_on_fail = FALSE)
}
\arguments{
\item{...}{arguments to pass to \code{\link{train}}.  These arguments will determine which train method gets dispatched.}

\item{trControl}{a \code{\link{trainControl}} object.  We are going to intercept this object check that it has the "index" slot defined, and define the indexes if they are not.}

\item{methodList}{optional, a character vector of caret models to ensemble.  One of methodList or tuneList must be specified.}

\item{tuneList}{optional, a NAMED list of caretModelSpec objects. This much more flexible than methodList and allows the specificaiton of model-specific parameters (e.g. passing trace=FALSE to nnet)}

\item{continue_on_fail, }{logical, should a valid caretList be returned that excludes models that fail, default is FALSE}
}
\value{
A list of \code{\link{train}} objects. If the model fails to build,
it is dropped from the list.
}
\description{
Create a list of several train models from the caret package
Build a list of train objects suitable for ensembling using the \code{\link{caretEnsemble}}
function.
}
\examples{
\dontrun{
myControl <- trainControl(method="cv", number=5)
caretList(
  Sepal.Length ~ Sepal.Width,
  head(iris, 50),
  methodList=c("glm", "lm"),
  trControl=myControl
  )
caretList(
  Sepal.Length ~ Sepal.Width,
  head(iris, 50), methodList=c("lm"),
  tuneList=list(
    nnet=caretModelSpec(method="nnet", trace=FALSE, tuneLength=1)
 ),
  trControl=myControl
  )
  }
}

