\name{spatialSign}
\alias{spatialSign}
\alias{spatialSign.default}
\alias{spatialSign.matrix}
\alias{spatialSign.data.frame}
\title{Compute the multivariate spatial sign}
\description{
Compute the spatial sign (a projection of a data vector to a unit length circle). The spatial sign of a vector \code{w} is \code{w /norm(w)}.
}
\usage{
\method{spatialSign}{default}(x)
\method{spatialSign}{matrix}(x)
\method{spatialSign}{data.frame}(x)
}
\arguments{
  \item{x}{an object full of numeric data (which should probably be scaled). Factors are not allowed. This could be a vector, matrix or data frame.}
}

\value{A vector, matrix or data frame with the same dim names of the original data.}
\author{Max Kuhn}
\references{Serneels et al. Spatial sign preprocessing: a simple way to impart moderate robustness to multivariate estimators. J. Chem. Inf. Model (2006) vol. 46 (3) pp. 1402-1409}
\examples{
spatialSign(rnorm(5))

spatialSign(matrix(rnorm(12), ncol = 3))

# should fail since the fifth column is a factor
try(spatialSign(iris), silent = TRUE)

spatialSign(iris[,-5])

trellis.par.set(caretTheme())
featurePlot(iris[,-5], iris[,5], "pairs")
featurePlot(spatialSign(scale(iris[,-5])), iris[,5], "pairs")
}
\keyword{manip} 
