% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_c4c_concept.R
\name{c4c_concept}
\alias{c4c_concept}
\title{User-Friendly Construction of a c4c_concept Object}
\usage{
c4c_concept(growth_and_yield, concept_name)
}
\arguments{
\item{growth_and_yield}{data.frame with at least two rows and the columns
"phase_no", "phase_name", "duration", "n_subphases", "vol_standing",
"vol_remove", "vol_mort", "dbh_standing", "dbh_remove", "n_standing",
"n_remove", "harvest_interval", and "survival_cum".}

\item{concept_name}{Character, name of the concept defined}
}
\value{
A valid object of class c4c_concept, if it can be constructed from
the input data; stops with an error otherwise. The object is basically a
list. Its most important ingredient is a tibble named
\code{growth_and_yield} which is a honed version of the input
\code{growth_and_yield} to this function. It contains, in addition, phase
wise periodical volume increments per ha (column \code{vol_increment}),
which result from the given information. There is no option for
user-provided volume increments in order to guarantee consistency.
}
\description{
For creating a c4c_concept object under normal circumstances, you should not
use the constructor \code{\link{new_c4c_concept}} directly, but this
function.
}
\details{
Special attention needs to be paid to the definition of \strong{vol_remove} in
cases when the standing volume decreases from one phase to the next. If the
value given for \code{vol_remove} is too low, it will result in a negative
volume increment for the respective phase. This will not pass the validation
called inside this function.
}
\examples{
  # construct dummy example (without real life relevance)
  g_and_y <- data.frame(
    phase_no         = 1:2,
    phase_name       = c("young", "older"),
    duration         = c(10, 10),
    n_subphases      = c(3, 3),
    vol_standing     = c(166, 304),
    vol_remove       = c(0, 23.6),
    vol_mort         = c(0.01, 0.11),
    n_standing       = c(3200, 970),
    n_remove         = c(0, 306),
    dbh_standing     = c(9.4, 22.3),
    dbh_remove       = c(0, 12.3),
    harvest_interval = c(0, 5),
    survival_cum     = c(0.999, 0.852)
  )

  dummy_concept <- c4c_concept(g_and_y, "dummy_concept")
  dummy_concept

}
