% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin-alg-advanced.R
\name{linalg}
\alias{linalg}
\alias{columnspace}
\alias{nullspace}
\alias{rowspace}
\alias{singular_values}
\alias{inv}
\alias{eigenval}
\alias{eigenvec}
\alias{GramSchmidt}
\alias{pinv}
\alias{rref}
\alias{QRdecomposition}
\alias{det}
\title{Do linear algebra operation}
\usage{
columnspace(x)

nullspace(x)

rowspace(x)

singular_values(x)

inv(x)

eigenval(x)

eigenvec(x)

GramSchmidt(x)

pinv(x)

rref(x)

QRdecomposition(x)

det(x, ...)
}
\arguments{
\item{x}{A matrix for which a property is requested}

\item{...}{Auxillary arguments}
}
\value{
Returns the requested property of a matrix.
}
\description{
Performs various linear algebra operations like finding the inverse,
the QR decomposition, the eigenvectors and the eigenvalues.
}
\examples{
if (has_sympy()) {
  A <- matrix(c("a", "0", "0", "1"), 2, 2) \%>\% as_sym()
  
  QRdecomposition(A)
  eigenval(A)
  eigenvec(A)
  inv(A)
  det(A)
  
  
  A <- matrix(c("a", "b", "c", "d"), 2, 2) \%>\% as_sym()
  evec <- eigenvec(A)
  evec
  evec1 <- evec[[1]]$eigvec
  evec1
  simplify(evec1)
  
  lapply(evec, function(l) simplify(l$eigvec))

  A <- as_sym("[[1, 2, 3], [4, 5, 6]]")
  pinv(A)
}

}
\seealso{
\code{\link[=do_la]{do_la()}}
}
\concept{linalg}
