## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- message=FALSE, echo=FALSE-----------------------------------------------
library(caracas)
##packageVersion("caracas")

## ---- include = FALSE---------------------------------------------------------
inline_code <- function(x) {
  x
}

if (!has_sympy()) {
  # SymPy not available, so the chunks shall not be evaluated
  knitr::opts_chunk$set(eval = FALSE)
  
  inline_code <- function(x) {
    deparse(substitute(x))
  }
}

## -----------------------------------------------------------------------------
A <- matrix(c("a", "b", "0", "1"), 2, 2) %>% as_sym()
A
A <- matrix_(c("a", "b", "0", "1"), 2, 2) # note the '_' postfix
A
A <- as_sym("[[a, 0], [b, 1]]")
A

A2 <- matrix_(c("a", "b", "c", "1"), 2, 2)
A2

B <- matrix_(c("a", "b", "0", 
              "c", "c", "a"), 2, 3)
B

b <- matrix_(c("b1", "b2"), nrow = 2)

D <- diag_(c("a", "b")) # note the '_' postfix
D

## -----------------------------------------------------------------------------
A + A2
A %*% B

## -----------------------------------------------------------------------------
A * A2

## -----------------------------------------------------------------------------
x <- as_sym(paste0("x", 1:3))
x
x + x
1 / x
x / x

## -----------------------------------------------------------------------------
reciprocal_matrix(A2)
reciprocal_matrix(A2, num = "2*a")

## -----------------------------------------------------------------------------
inv(A)
x <- solve_lin(A, b)
x
A %*% x ## Sanity check

## -----------------------------------------------------------------------------
M <- as_sym("[[1, 2, 3], [4, 5, 6]]")
pinv(M)
B <- as_sym("[[7], [8]]") 
B
z <- do_la(M, "pinv_solve", B)
print(z, rowvec = FALSE) # Do not print column vectors as transposed row vectors

## -----------------------------------------------------------------------------
A <- matrix(c("a", "0", "0", "1"), 2, 2) %>% as_sym()
A
qr_res <- QRdecomposition(A)
qr_res$Q
qr_res$R

## -----------------------------------------------------------------------------
eigenval(A)

## -----------------------------------------------------------------------------
evec <- eigenvec(A)
evec
evec1 <- evec[[1]]$eigvec
evec1
simplify(evec1)

lapply(evec, function(l) simplify(l$eigvec))

## -----------------------------------------------------------------------------
inv(A)
pinv(cbind(A, A)) # pseudo inverse

## -----------------------------------------------------------------------------
args(do_la)

## -----------------------------------------------------------------------------
do_la(A, "QRdecomposition") # == QRdecomposition(A)
do_la(A, "inv")             # == inv(A)
do_la(A, "eigenvec")        # == eigenvec(A)
do_la(A, "eigenvals")       # == eigenval(A)

## -----------------------------------------------------------------------------
cp <- do_la(A, "charpoly")
cp
as_expr(cp)

## -----------------------------------------------------------------------------
do_la(A, "rank")

## -----------------------------------------------------------------------------
A <- matrix(c("a", "b", "0", "1"), 2, 2) %>% as_sym()
A
do_la(A, "cofactor", 0, 1)
do_la(A, "cofactor_matrix")

## -----------------------------------------------------------------------------
do_la(cbind(A, A), "echelon_form")

## -----------------------------------------------------------------------------
B <- as_sym("[[9, 3*I], [-3*I, 5]]")
B
do_la(B, "cholesky")

## -----------------------------------------------------------------------------
B <- t(as_sym("[[ 2, 3, 5 ], [3, 6, 2], [8, 3, 6]]"))
do_la(B, "GramSchmidt")

## -----------------------------------------------------------------------------
B <- t(as_sym("[[ 2, 3, 5 ], [4, 6, 10], [8, 3, 6] ]"))
B
B_rref <- do_la(B, "rref")
B_rref

## -----------------------------------------------------------------------------
B <- matrix(c(1, 3, 0, -2, -6, 0, 3, 9, 6), nrow = 3) %>% as_sym()
B
columnspace(B)
rowspace(B)
x <- nullspace(B)
x
rref(B)
B %*% x[[1]]

## -----------------------------------------------------------------------------
B <- t(as_sym("[[ 2, 3, 5 ], [4, 6, 10], [8, 3, 6], [8, 3, 6] ]"))
B
singular_values(B)

