% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge_and_understanding.R
\name{get_fill_in_the_blanks_score}
\alias{get_fill_in_the_blanks_score}
\title{Compute a fill in the blanks score.}
\usage{
get_fill_in_the_blanks_score(
  pa_is = NA,
  pa_is_also = NA,
  improve = NA,
  increase = NA,
  when_cooling_down = NA,
  heart_rate = NA
)
}
\arguments{
\item{pa_is}{A vector representing a response to the first fill in the blank item (correct answers are 1, 7, "Fun" or "Good").}

\item{pa_is_also}{A vector representing a response to the second fill in the blank item (correct answers are 1, 7, "Fun" or "Good").}

\item{improve}{A vector representing a response to the third fill in the blank item (correct answers are 3 or "Endurance").}

\item{increase}{A vector representing a response to the fourth fill in the blank item (correct answers are 8 or "Strength").}

\item{when_cooling_down}{A vector representing a response to the fifth fill in the blank item (correct answers are 2 or "Stretches").}

\item{heart_rate}{A vector representing a response to the sixth fill in the blank item (correct answers are 4 or "Pulse").}
}
\value{
Returns a numeric (integer) vector with values between 0 and 5 (if valid) or NA (if not valid).
}
\description{
This function computes a score (\code{fill_in_the_blanks_score}) for responses to the fill in the blanks items (story about Sally) in
\href{https://www.capl-eclp.ca/wp-content/uploads/2018/02/CAPL-2-questionnaire.pdf}{the CAPL-2 Questionnaire}. This score is used to compute the knowledge
and understanding domain score (\code{ku_score}).
}
\details{
The following integers represent the responses for the items/arguments in this function:
\itemize{
\item 1 = Fun
\item 2 = Stretches
\item 3 = Endurance
\item 4 = Pulse
\item 5 = Breathing
\item 6 = Flexibility
\item 7 = Good
\item 8 = Strength
\item 9 = Bad
\item 10 = Sport
}

Other \code{capl} functions called by this function include: \code{\link[=get_binary_score]{get_binary_score()}}.
}
\examples{
get_fill_in_the_blanks_score(
  pa_is = c(2, 3, "fun", 9),
  pa_is_also = c(2, 5, "Fun", 9),
  improve = c(1, 3, 10, "Endurance"),
  increase = c(2, 3.5, "strength", "strength"),
  when_cooling_down = c("stretches", 9, 2, ""),
  heart_rate = c(3, 9, 4, "pulse")
)

# [1] 0 1 3 1

}
